<?php

declare(strict_types=1);

namespace Erlage\Photogram\Data\Tables\Sys;

use Exception;

trait PreventModelGenerationTrait
{
    /*
    |--------------------------------------------------------------------------
    | required attributes
    |--------------------------------------------------------------------------
    */

    public static function getPrimaryAttribute(): string
    {
        return 'id';
    }

    public static function getRegistrationStampAttribute(): string
    {
        throw new Exception('Table not supported for Model generation');
    }

    public static function getLastUpdateStampAttribute(): string
    {
        throw new Exception('Table not supported for Model generation');
    }

    public static function getOwnerAttribute(): string
    {
        throw new Exception('Table not supported for Model generation');
    }

    /*
    |--------------------------------------------------------------------------
    | requried properties getter
    |--------------------------------------------------------------------------
    */

    public static function allAttributes(): array
    {
        throw new Exception('Table not supported for Model generation');
    }

    /*
    |--------------------------------------------------------------------------
    | meta getters
    |--------------------------------------------------------------------------
    */

    public static function getModelClassName(): string
    {
        throw new Exception('Table not supported for Model generation');
    }

    public static function getTableName(): string
    {
        return '';
    }
}
